#ifndef __CPopupButton__
#define __CPopupButton__

#include "CLatchingButton.hpp"
#include "CMenu.hpp"
#include "../Windowing/CMenuWindow.hpp"
#include "../Listeners/IMenuListener.hpp"

//	===========================================================================

using Exponent::GUI::Windowing::CMenuWindow;
using Exponent::GUI::Controls::CLatchingButton;
using Exponent::GUI::Controls::CMenu;
using Exponent::GUI::Listeners::IMenuListener;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @interface CPopupButton CPopupButton.hpp
			 * @brief Pops up a menu when the button is clicked
			 *
			 * @date 22/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CPopupButton.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CPopupButton : public CLatchingButton, public IMenuListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 * @param menu The menu to display on click
				 */
				CPopupButton(IControlRoot *root, const long uniqueId, const CRect &area, CMenu *menu, IActionListener *listener);

				/**
				 * Destruction
				 */
				virtual ~CPopupButton();

//	===========================================================================

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle a menu selection
				 * @param event The event to handle
				 */
				virtual void handleMenuSelection(const CMenuEvent &event);

				/**
				 * Handle a menu opening
				 * @param event The event to handle
				 */
				virtual void handleMenuOpening(const CMenuEvent &event) {}

				/**
				 * Handle a menu closing
				 * @param event The event to handle
				 */
				virtual void handleMenuClosing(const CMenuEvent &event);

//	===========================================================================

				/**
				 * Set the menu
				 * @param menu The menu to display
				 */
				virtual void setMenu(CMenu *menu);

				/**
				 * Get the menu
				 * @retval CMenu* The menu
				 */
				virtual CMenu *getMutableMenu() { return m_menu; }

				/**
				 * Get the menu
				 * @retval const CMenu* The menu
				 */
				virtual const CMenu *getMenu() const { return m_menu; }

				/**
				 * Get the last menu event
				 * @retval CMenuEvent* The last menu event recieved
				 */
				virtual CMenuEvent *getLastMenuEvent() const { return myMenuEvent; }

//	===========================================================================

				/**
				 * Set menu window attributes
				 * @param windowAttributes The attributes for the menu window
				 * @param useIcons If true icons are displayed for menu items, if false they are not
				 */
				virtual void setMenuWindowAttributes(CWindowAttributes *windowAttributes, const bool useIcons = true);

				/**
				 * Get the menu window
				 * @retval CMenuWindow* The menu window
				 */
				virtual CMenuWindow *getMenuWindow() const { return m_menuWindow; }

//	===========================================================================

			protected:

//	===========================================================================

				CMenu *m_menu;								/**< The menu to display */				
				CMenuWindow *m_menuWindow;					/**< The menu window */
				CWindowAttributes *m_windowAttributes;		/**< The window attributes */
				CMenuEvent *myMenuEvent;					/**< The menu event to send to listeners */
				bool m_useIcons;							/**< If true menu window draws icons */
			};
		}
	}
}
#endif	// End of CPopupButton.hpp